/*
 * Decompiled with CFR 0.152.
 */
package sedonac.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SCodeGen {
    private static String[] SPACES = new String[50];
    static int nextOpcode;
    static Op[] ops;
    static Constant[] constants;

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        File file = new File(stringArray[1]);
        File file2 = new File(stringArray[2]);
        File file3 = new File(stringArray[3]);
        System.out.println();
        System.out.println("lang:  " + string);
        System.out.println("data:  " + file);
        System.out.println("in:    " + file2);
        System.out.println("out:   " + file3);
        SCodeGen.readData(file);
        if (string.equals("java")) {
            SCodeGen.writeJava(file2, file3);
        } else {
            SCodeGen.writeH(file2, file3);
        }
        System.out.println("done!");
        System.out.println();
    }

    static void writeJava(File file, File file2) throws Exception {
        String[] stringArray = SCodeGen.readLines(file);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].trim();
            if (string.equals("$opcodes")) {
                SCodeGen.printJavaOps(printWriter);
            } else if (string.equals("$constants")) {
                SCodeGen.printJavaConstants(printWriter);
            } else {
                printWriter.println(stringArray[n]);
            }
            ++n;
        }
        printWriter.close();
    }

    static void printJavaOps(PrintWriter printWriter) {
        Op op;
        int n = 0;
        while (n < ops.length) {
            op = ops[n];
            if (op.id < 0) {
                printWriter.println();
                printWriter.println("  " + op.comment);
            } else {
                printWriter.println("  public static final int " + SCodeGen.pad(op.name, 18) + " = " + SCodeGen.pad("" + op.id + ';', 6) + op.comment);
            }
            ++n;
        }
        printWriter.println();
        printWriter.println("  // OpCodes by name");
        printWriter.println("  public static final String[] names =");
        printWriter.println("  {");
        n = 0;
        while (n < ops.length) {
            op = ops[n];
            if (op.id >= 0) {
                printWriter.println("    \"" + SCodeGen.pad(op.name + "\",", 20) + " // " + op.id);
            }
            ++n;
        }
        printWriter.println("  };");
        printWriter.println();
        printWriter.println("  // OpCodes arguments");
        printWriter.println("  public static int argType(int opcode)");
        printWriter.println("  {");
        printWriter.println("    switch(opcode)");
        printWriter.println("    {");
        n = 0;
        while (n < ops.length) {
            op = ops[n];
            if (op.arg != null) {
                printWriter.println("      case " + SCodeGen.pad(op.name + ':', 20) + " return " + op.arg + "Arg;");
            }
            ++n;
        }
        printWriter.println("      default:                  return noArg;");
        printWriter.println("    }");
        printWriter.println("  }");
    }

    static void printJavaConstants(PrintWriter printWriter) {
        int n = 0;
        while (n < constants.length) {
            Constant constant = constants[n];
            printWriter.println("  public static final " + constant.type + ' ' + SCodeGen.pad(constant.name, 14) + " = " + SCodeGen.pad(constant.value + ';', 8) + ' ' + constant.comment);
            ++n;
        }
    }

    static void writeH(File file, File file2) throws Exception {
        String[] stringArray = SCodeGen.readLines(file);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].trim();
            if (string.equals("$opcodes")) {
                SCodeGen.printHOps(printWriter);
            } else if (string.equals("$opcodeLabels")) {
                SCodeGen.printHOpLabels(printWriter);
            } else if (string.equals("$debug")) {
                SCodeGen.printHDebug(printWriter);
            } else if (string.equals("$constants")) {
                SCodeGen.printHConstants(printWriter);
            } else {
                printWriter.println(stringArray[n]);
            }
            ++n;
        }
        printWriter.close();
    }

    static void printHOps(PrintWriter printWriter) {
        int n = 0;
        while (n < ops.length) {
            Op op = ops[n];
            if (op.id < 0) {
                printWriter.println();
                printWriter.println(op.comment);
            } else {
                printWriter.println("#define " + SCodeGen.pad(op.name, 18) + "  " + op.id);
            }
            ++n;
        }
        printWriter.println();
        printWriter.println("#define " + SCodeGen.pad("NumOpcodes", 18) + "  " + nextOpcode);
    }

    static void printHOpLabels(PrintWriter printWriter) {
        printWriter.println("#define OpcodeLabelsArray \\");
        printWriter.println("{ \\");
        int n = -1;
        int n2 = 0;
        while (n2 < ops.length) {
            Op op = ops[n2];
            if (op.id >= 0) {
                if (op.id != n + 1) {
                    throw new IllegalStateException("last=" + n + " id=" + op.id);
                }
                printWriter.println("&&" + op.name + ", \\");
                n = op.id;
            }
            ++n2;
        }
        printWriter.print("}");
        printWriter.println();
    }

    static void printHDebug(PrintWriter printWriter) {
        Op op;
        printWriter.println("#ifdef SCODE_DEBUG");
        printWriter.println();
        printWriter.println("// OpCodes by name");
        printWriter.println("const char* OpcodeNames[] =");
        printWriter.println("{");
        int n = 0;
        while (n < ops.length) {
            op = ops[n];
            if (op.id >= 0) {
                printWriter.println("  \"" + SCodeGen.pad(op.name + "\",", 20) + " // " + op.id);
            }
            ++n;
        }
        printWriter.println("};");
        printWriter.println();
        printWriter.println("// pointer offset used for null pointer check");
        printWriter.println("const int8_t OpcodePointerOffsets[] =");
        printWriter.println("{");
        n = 0;
        while (n < ops.length) {
            op = ops[n];
            if (op.id >= 0) {
                printWriter.println("  " + SCodeGen.padLeft("" + op.offset + ',', 4) + "   // " + op.id + ' ' + op.name);
            }
            ++n;
        }
        printWriter.println("};");
        printWriter.println();
        printWriter.println("#endif");
    }

    static void printHConstants(PrintWriter printWriter) {
        int n = 0;
        while (n < constants.length) {
            Constant constant = constants[n];
            printWriter.println("#define " + SCodeGen.pad(constant.name, 14) + ' ' + constant.value);
            ++n;
        }
    }

    static void readData(File file) throws Exception {
        String[] stringArray = SCodeGen.readLines(file);
        ArrayList<Op> arrayList = new ArrayList<Op>();
        ArrayList<Constant> arrayList2 = new ArrayList<Constant>();
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].trim();
            if (string2.length() != 0 && !string2.startsWith("--")) {
                if (string2.startsWith("$")) {
                    string = string2;
                } else if (string.equals("$opcodes")) {
                    arrayList.add(SCodeGen.parseOp(string2));
                } else if (string.equals("$constants")) {
                    arrayList2.add(SCodeGen.parseConstant(string2));
                } else {
                    throw new IllegalStateException("key = " + string);
                }
            }
            ++n;
        }
        ops = arrayList.toArray(new Op[arrayList.size()]);
        constants = arrayList2.toArray(new Constant[arrayList2.size()]);
    }

    static Op parseOp(String string) {
        int n = string.indexOf(47);
        if (n == 0) {
            Op op = new Op();
            op.id = -1;
            op.comment = string;
            return op;
        }
        String string2 = string.substring(n);
        String[] stringArray = SCodeGen.split(string.substring(0, n));
        String string3 = stringArray[0];
        String string4 = null;
        int n2 = -1;
        if (stringArray.length == 2) {
            try {
                n2 = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                string4 = stringArray[1];
            }
        } else if (stringArray.length == 3) {
            string4 = stringArray[1];
            n2 = Integer.parseInt(stringArray[2]);
        }
        Op op = new Op();
        op.id = nextOpcode++;
        op.name = string3;
        op.arg = string4;
        op.offset = n2;
        op.comment = string2;
        return op;
    }

    static String[] split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static Constant parseConstant(String string) {
        int n = string.indexOf(47);
        String string2 = string.substring(n);
        String string3 = string.substring(0, n).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " =");
        Constant constant = new Constant();
        constant.type = stringTokenizer.nextToken().trim();
        constant.name = stringTokenizer.nextToken().trim();
        constant.value = stringTokenizer.nextToken().trim();
        constant.comment = string2;
        return constant;
    }

    public static String[] readLines(File file) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getSpaces(int n) {
        return SPACES[n];
    }

    public static String pad(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string).append(SCodeGen.getSpaces(n - string.length()));
        return stringBuffer.toString();
    }

    public static String padLeft(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(SCodeGen.getSpaces(n - string.length())).append(string);
        return stringBuffer.toString();
    }

    static {
        SCodeGen.SPACES[0] = "";
        int n = 1;
        while (n < 50) {
            SCodeGen.SPACES[n] = SPACES[n - 1] + ' ';
            ++n;
        }
        nextOpcode = 0;
    }

    static class Op {
        int id;
        String name;
        String arg;
        int offset;
        String comment;

        Op() {
        }
    }

    static class Constant {
        String type;
        String name;
        String value;
        String comment;

        Constant() {
        }
    }
}

